/**************************************************************************** *
 * FILE :
 *  Control_system_2020_dsrtmdlfcn.cpp
 *
 *
 *
 * Copyright 2017, dSPACE GmbH. All rights reserved
 *
   \****************************************************************************/

#ifndef TEMP_DSRT_RTI
#include <rtmodel.h>
#include "rtwtypes.h"
#include "Control_system_2020_dsrtmdlfcn.h"
#include <stdio.h>

int32_T DSRTStopSimulation = 0;
EXTERN_C_DECL void Control_system_2020_initialize();
EXTERN_C_DECL void Control_system_2020_terminate();

/* Initialization of model */
void Control_system_2020_DSRTInitMdl(void)
{
  /* Initialize model */
  Control_system_2020_initialize();

  /* Check for initialization errors */
  Control_system_2020_DSRTCheckForErrorStatus();

  /* Reinit Stop Simulation flag*/
  DSRTStopSimulation = 0;
}

/* Model start function */
void Control_system_2020_DSRTStartMdl(void)
{
  uint8_T lastApplStateStopped;
  Control_system_2020_APLastApplStateStopped(&lastApplStateStopped);
  if (lastApplStateStopped) {
    /* Reinit main simulation structure */
    Control_system_2020_DSRTInitMdl();
  }
}

/* Model stop function */
void Control_system_2020_DSRTStopMdl(void)
{
  /* Call terminate function */
  Control_system_2020_terminate();

  /* Check for model error status */
  Control_system_2020_DSRTCheckForErrorStatus();
}

/* Check for model error status */
void Control_system_2020_DSRTCheckForErrorStatus()
{
  const char_T* errorStatus = rtmGetErrorStatus(Control_system_2020_M);
  if (errorStatus != NULL && strcmp(errorStatus, "Simulation finished") == 0) {
    /* The RTM errorStatus field has been set */
    Control_system_2020_APTerminateSimulation();
    Control_system_2020_APPrintMessage(
      "Model 'Control_system_2020' error status:");
    Control_system_2020_APPrintMessage(errorStatus);
  }
}

/* Check for simulation stop conditions */
void Control_system_2020_DSRTCheckForSimulationStopCondition(void)
{
  const char_T* errorStatus = rtmGetErrorStatus(Control_system_2020_M);
  double stopTime = 1369.0;
  if (stopTime > 0.0 && Control_system_2020_M->Timing.t[0] > stopTime) {
    if (DSRTStopSimulation != 1) {
      /* The simulation stop time has been reached */
      Control_system_2020_APStopSimulation();
      Control_system_2020_APPrintMessage(
        "Model 'Control_system_2020': Reached the model simulation stop time 1369.0.");
      DSRTStopSimulation = 1;
    }
  } else if (errorStatus != NULL) {
    if (DSRTStopSimulation != 1) {
      /* The RTM errorStatus field was set */
      Control_system_2020_APTerminateSimulation();
      Control_system_2020_APPrintMessage(
        "Model 'Control_system_2020' error status:");
      Control_system_2020_APPrintMessage(errorStatus);
      DSRTStopSimulation = 1;
    }
  } else if (rtmGetStopRequested(Control_system_2020_M)) {
    if (DSRTStopSimulation != 1) {
      Control_system_2020_APStopSimulation();
      Control_system_2020_APPrintMessage(
        "Model 'Control_system_2020': Executed a Simulink Stop Simulation block or request.");
      DSRTStopSimulation = 1;
    }
  }
}

#endif
